<?php
  $re_name     = '([a-zA-Z][a-zA-Z0-9_]*)';
  $re_value    = '(["][^"]*["])';
  $re_list     = '[(]([^\)]*[)])';
  $re_const    = '/const\s+string\s+' . $re_name . '\s*=\s*(' . $re_value . '|' . $re_list . ')/';
  $re_variants = '/' . $re_name . '\s*=\s*' . $re_value . '/';

  // Read the text from STDIN
  $data = file_get_contents( "php://stdin" );
  
  // Extract from the text all constants
  preg_match_all( $re_const, $data, $constants, PREG_SET_ORDER, 0 );

  // Process all constants
  foreach ( $constants as $const )
  {
    // Single language constant
    if ( str_starts_with( $const[2], '"' ))
      file_put_contents( 'lang_Default.txt', "{$const[1]}={$const[2]}\n", FILE_APPEND );
    
    // Multi-lingual constant
    else
    {
      // Process the language specific values of the cnstant
      preg_match_all( $re_variants, $const[2], $variants, PREG_SET_ORDER, 0 );
      
      foreach ( $variants as $variant )
        file_put_contents( "lang_{$variant[1]}.txt", "{$const[1]}={$variant[2]}\n", FILE_APPEND );
    }
  }
?>