<?php
  $re_name    = '([a-zA-Z][a-zA-Z0-9_]*)';
  $re_value   = '(["][^"]*["])';
  $re_const   = '/'. $re_name . '\s*=\s*' . $re_value . '/';
  $lang_files = glob( 'lang_*.txt' );
  $results    = [];

  // Read the strings from different language specific files
  foreach ( $lang_files as $lang_file )
  {
    $lang_name = substr( $lang_file, 5, -4 );
    $data      = file_get_contents( $lang_file );

    // Extract from the text all constants
    preg_match_all( $re_const, $data, $constants, PREG_SET_ORDER, 0 );

    // Process all constants
    foreach ( $constants as $const )
    {
      if ( !array_key_exists( $const[1], $results ))
        $results[$const[1]] = [];

      $results[$const[1]][$lang_name]=$const[2];
    }
  }

  // The list of resulting constants
  $const_names = array_keys( $results );

  // Start Chora Synthese
  echo '$version 14.00' . "\n";
  echo '$scope' . "\n";

  // Process all constants
  foreach ( $const_names as $const_name )
  {
    $const_values = $results[$const_name];
    $const_langs  = array_keys( $const_values );

    // Start of a constant
    echo '$output false' . "\n";
    echo "const string {$const_name}=\n(\n";

    // Append language specific values of the constants
    foreach ( $const_langs as $const_lang )
    echo "  {$const_lang}={$const_values[$const_lang]};\n";

    // End of a constant
    echo ");\n";
  }
?>